<?php
include_once '../conexion.php';

// Obtener los datos combinados del cuerpo de la solicitud
$data = json_decode(file_get_contents("php://input"), true);



// Iniciar la transacción
mysqli_autocommit($conn, false);
// Variable para verificar el estado de la transacción
$transaccionExitosa = true;
$errorMensaje = "";

try {
    // Acceder a los valores individuales de los datos combinados
    $cCodProd = $data['CodProd'];
    $cNombre = $data['Nombre'];
    $cCodBar = $data['CodBar'];
    $cCodSunat = $data['CodSunat'];
    $cCodExt = $data['CodExt'];
    $cAfectoIGV = $data['AfectoIGV'];
    $cPorcentajeIGV = $data['PorcentajeIGV'];
    $cPeso = $data['Peso'];
    $cStockMinimo = $data['StockMinimo'];
    $cPCompraAnt = $data['PCompraAnt'];
    $cFCompraAnt = $data['FCompraAnt'];
    $cDocCompraAnt = $data['DocCompraAnt'];
    $cUltPCompra = $data['UltPCompra'];
    $cUltFCompra = $data['UltFCompra'];
    $cUltDocCompra = $data['UltDocCompra'];
    $cUnidadId = $data['UnidadId'];
    $cCapacidad = $data['Capacidad'];
    $cFraccionId = $data['FraccionId'];
    $cImporteICBP = $data['ImporteICBP'];
    $cDescripcion = $data['Descripcion'];
    $cActivo = $data['Activo'];
    $cContenido = $data['Contenido'];
    $cInformacion = $data['Informacion'];
    $cPathFoto = $data['PathFoto'];
    $cCategoriaId = $data['CategoriaId'];
    $cMarcaId = $data['MarcaId'];
    $cModeloId = $data['ModeloId'];
    $cPPrecio_Menor = $data['PPrecio_Menor'];
    $cPPrecio_Mayor = $data['PPrecio_Mayor'];
    $cPPrecio_Dist = $data['PPrecio_Dist'];
    $cPrecMenor_und = $data['PrecMenor_und'];
    $cPrecmenor_Fra = $data['Precmenor_Fra'];
    $cPrecmayor_Und = $data['Precmayor_Und'];
    $cPrecmayor_Fra = $data['Precmayor_Fra'];
    $cPrecdist_Und = $data['Precdist_Und'];
    $cPrecdist_Fra = $data['Precdist_Fra'];
    $cFecha_Inventario = $data['Fecha_Inventario'];
    $cStock = $data['Stock'];
    $cStockF = $data['StockF'];
    $cCosto = $data['Costo'];
    $cAlmacenId = $data['AlmacenId'];
    $cEmpresaId = $data['EmpresaId'];
    $cSucursalId = $data['SucursalId'];
    $nIdProd = $data['nIdProd'];
    $cEstado = $data['Estado'];

    if ($cEstado == 'NUEVO') {

        // Ejemplo de inserción en la tabla productos
        $queryProducto = "INSERT INTO productos(codigo_producto, nombre, codigo_barras, codigo_sunat, codigo_externo, afecto_igv, porcentaje_igv, peso, 
            stock_minimo, pcompra_ant, fcompra_ant, doccompra_ant, ult_pcompra, ult_fcompra, ult_doccompra, unidad_id, capacidad, fraccion_id,
            importe_icbp, pprecio_menor, pprecio_mayor, pprecio_dist, precmenor_und, precmenor_fra, precmayor_und, precmayor_fra, precdist_und, precdist_fra,
            descripcion, activo, contenido, informacion, path_foto, categoria_id, marca_id, modelo_id, empresa_id)
        VALUES('$cCodProd', '$cNombre', '$cCodBar', '$cCodSunat', '$cCodExt', '$cAfectoIGV', '$cPorcentajeIGV', '$cPeso', '$cStockMinimo', '$cPCompraAnt', '$cFCompraAnt', 
            '$cDocCompraAnt', '$cUltPCompra', '$cUltFCompra', '$cUltDocCompra', '$cUnidadId', '$cCapacidad', '$cFraccionId', '$cImporteICBP', 
            '$cPPrecio_Menor', '$cPPrecio_Mayor', '$cPPrecio_Dist', '$cPrecMenor_und', '$cPrecmenor_Fra', '$cPrecmayor_Und', '$cPrecmayor_Fra', '$cPrecdist_Und', '$cPrecdist_Fra',
            '$cDescripcion', '$cActivo', '$cContenido', '$cInformacion', '$cPathFoto', '$cCategoriaId', '$cMarcaId', '$cModeloId', '$cEmpresaId')";

        $resultadoProducto = mysqli_query($conn, $queryProducto);
        if (!$resultadoProducto) {
            throw new Exception(mysqli_error($conn));
        }

        // Obtener el ID del último registro insertado
        $IdProd = mysqli_insert_id($conn);
        
        // Ejemplo de inserción en la tabla equivalencia
        foreach ($data['equivalencias'] as $equivalencias_) {
            $cnombre = $equivalencias_['nombre'];
            $cCapacidad_Equiv = $equivalencias_['capacidad_precio'];
            $cAbrev = $equivalencias_['abrev_precio'];
            $cAbrev_Universal = $equivalencias_['abrev_universal'];
            $cPrecio_Venta = $equivalencias_['precio_venta'];

            $queryEquivalencia = "INSERT INTO equivalencias(producto_id, nombre, capacidad_precio, abrev_precio, abrev_universal, precio_venta, 
                empresa_id, sucursal_id)
            VALUES('$IdProd', '$cnombre', '$cCapacidad_Equiv', '$cAbrev', '$cAbrev_Universal', '$cPrecio_Venta', '$cEmpresaId', '$cSucursalId')";
            
            $resultadoEquivalencia = mysqli_query($conn, $queryEquivalencia);
            if (!$resultadoEquivalencia) {
                throw new Exception(mysqli_error($conn));
            }
        }
        
        if (($cStock + $cStockF) > 0) {
           $queryKardex = "INSERT INTO kardex(nserie, ndocumento, fecha_emision, fecha_traslado, operacion, producto_id, codigo_producto, entrada, costo, 
                salida, precio_venta, recogido, vencimiento, lote, transito, razon_social, observacion, unidad_medida, empresa_id, sucursal_id, 
                almacen_id, compra_id, venta_id, capacidad_Precio, docfiscal_id, categoria_id, marca_id, modelo_id)
               VALUES('INV1', '00000001', '$cFecha_Inventario', '$cFecha_Inventario', 'INV', '$IdProd', '$cCodProd', (('$cStock'*'$cCapacidad') + '$cStockF'),
               '$cCosto', 0, '$cCosto', (('$cStock'*'$cCapacidad') + '$cStockF'), '-', '-', 0, 'AJUSTE', 'INVENTARIO INICIAL', 
                'UND', '$cEmpresaId', '$cSucursalId', '$cAlmacenId', '0', 0,  '$cCapacidad', '1', '$cCategoriaId', '$cMarcaId',
                '$cModeloId')";
         
            $resultadoKardex = mysqli_query($conn, $queryKardex);
            if (!$resultadoKardex) {
                throw new Exception(mysqli_error($conn));
            }
        }

    } elseif ($cEstado == 'MODIFICAR') { 
        $queryUpd_Equivalencia = "UPDATE equivalencias SET IUD = 'D' WHERE producto_id = $nIdProd";
        $resultadoUpd_Equivalencia = mysqli_query($conn, $queryUpd_Equivalencia);        
        if (!$resultadoUpd_Equivalencia) {
            throw new Exception(mysqli_error($conn));
        }
        
        /*$queryUpd_Kardex = "UPDATE kardex SET IUD = 'D' WHERE operacion = 'INV' AND almacen_id = $cAlmacenId AND producto_id = $nIdProd";
        $resultadoUpd_Kardex = mysqli_query($conn, $queryUpd_Kardex);        
        if (!$resultadoUpd_Kardex) {
            throw new Exception(mysqli_error($conn));
        }*/
        
        $queryUpd_Producto = "UPDATE productos SET codigo_producto = '$cCodProd', nombre = '$cNombre', codigo_barras = '$cCodBar', codigo_sunat = '$cCodSunat', 
            codigo_externo = '$cCodExt', afecto_igv = '$cAfectoIGV', porcentaje_igv = '$cPorcentajeIGV', peso = '$cPeso', stock_minimo = '$cStockMinimo',
            pcompra_ant = '$cPCompraAnt', fcompra_ant = '$cFCompraAnt', doccompra_ant = '$cDocCompraAnt', ult_pcompra = '$cUltPCompra', 
            ult_fcompra = '$cUltFCompra', ult_doccompra = '$cUltDocCompra', unidad_id = '$cUnidadId', capacidad = '$cCapacidad', fraccion_id = '$cFraccionId',
            importe_icbp = '$cImporteICBP', pprecio_menor = '$cPPrecio_Menor', pprecio_mayor = '$cPPrecio_Mayor', pprecio_dist = '$cPPrecio_Dist', 
            precmenor_und = '$cPrecMenor_und', precmenor_fra = '$cPrecmenor_Fra', precmayor_und = '$cPrecmayor_Und', precmayor_fra = '$cPrecmayor_Fra', 
            precdist_und = '$cPrecdist_Und', precdist_fra = '$cPrecdist_Fra', descripcion = '$cDescripcion', activo = '$cActivo', contenido = '$cContenido',
            informacion = '$cInformacion', path_foto = '$cPathFoto', categoria_id = '$cCategoriaId', marca_id = '$cMarcaId', modelo_id = '$cModeloId', empresa_id = '$cEmpresaId'
        WHERE id = $nIdProd";
        
        $resultadoUpd_Producto = mysqli_query($conn, $queryUpd_Producto);        
        if (!$resultadoUpd_Producto) {
            throw new Exception(mysqli_error($conn));
        }

        // Ejemplo de inserción en la tabla equivalencia
        foreach ($data['equivalencias'] as $equivalencias_) {
            $cnombre = $equivalencias_['nombre'];
            $cCapacidad_Equiv = $equivalencias_['capacidad_precio'];
            $cAbrev = $equivalencias_['abrev_precio'];
            $cAbrev_Universal = $equivalencias_['abrev_universal'];
            $cPrecio_Venta = $equivalencias_['precio_venta'];

            $queryEquivalencia = "INSERT INTO equivalencias(producto_id, nombre, capacidad_precio, abrev_precio, abrev_universal, precio_venta, 
                empresa_id, sucursal_id)
            VALUES('$nIdProd', '$cnombre', '$cCapacidad_Equiv', '$cAbrev', '$cAbrev_Universal', '$cPrecio_Venta', '$cEmpresaId', '$cSucursalId')";
            
            $resultadoEquivalencia = mysqli_query($conn, $queryEquivalencia);
            if (!$resultadoEquivalencia) {
                throw new Exception(mysqli_error($conn));
            }
        }
        
        if (($cStock + $cStockF) > 0) {
            $queryCountKardex = "SELECT COUNT(id) FROM kardex WHERE operacion = 'INV' AND almacen_id = $cAlmacenId AND producto_id = $nIdProd";
            $result_Kardex = mysqli_query($conn, $queryCountKardex); // Suponiendo que has establecido una conexión a la base de datos ($conexion)
            if (!$result_Kardex) {
               // Manejo de error si la consulta falla
               die("Error al ejecutar la consulta: " . mysqli_error($conn));
            }
              
            $row_ = mysqli_fetch_array($result_Kardex);
            $count_ = $row_[0];
            if ($count_ == 0) {
                $queryKardex = "INSERT INTO kardex(nserie, ndocumento, fecha_emision, fecha_traslado, operacion, producto_id, codigo_producto, entrada, costo, 
                    salida, precio_venta, recogido, vencimiento, lote, transito, razon_social, observacion, unidad_medida, empresa_id, sucursal_id, 
                    almacen_id, compra_id, venta_id, capacidad_Precio, docfiscal_id, categoria_id, marca_id, modelo_id)
                   VALUES('INV1', '00000001', '$cFecha_Inventario', '$cFecha_Inventario', 'INV', '$nIdProd', '$cCodProd', (('$cStock'*'$cCapacidad') + '$cStockF'),
                   '$cCosto', 0, '$cCosto', (('$cStock'*'$cCapacidad') + '$cStockF'), '-', '-', 0, 'AJUSTE', 'INVENTARIO INICIAL', 
                    'UND', '$cEmpresaId', '$cSucursalId', '$cAlmacenId', '0', 0,  '$cCapacidad', '1', '$cCategoriaId', '$cMarcaId',
                    '$cModeloId')";
             
                $resultadoKardex = mysqli_query($conn, $queryKardex);
                if (!$resultadoKardex) {
                    throw new Exception(mysqli_error($conn));
                }
            } else {
                $queryUpd_Kardex = "UPDATE kardex SET entrada = (('$cStock'*'$cCapacidad') + '$cStockF'), recogido = (('$cStock'*'$cCapacidad') + '$cStockF'), costo = '$cCosto', fecha_traslado = '$cFecha_Inventario' WHERE operacion = 'INV' AND almacen_id = $cAlmacenId AND producto_id = $nIdProd";
                    
                print_r("CONSULTA KARDEX : " .$queryUpd_Kardex);
                    
                $resultadoUpd_Kardex = mysqli_query($conn, $queryUpd_Kardex);        
                if (!$resultadoUpd_Kardex) {
                        throw new Exception(mysqli_error($conn));
                } 
            }    
            
        } else {
            $queryUpd_Kardex = "UPDATE kardex SET entrada = (('$cStock'*'$cCapacidad') + '$cStockF'), recogido = (('$cStock'*'$cCapacidad') + '$cStockF'), costo = '$cCosto', fecha_traslado = '$cFecha_Inventario' WHERE operacion = 'INV' AND almacen_id = $cAlmacenId AND producto_id = $nIdProd";
                
            print_r("CONSULTA KARDEX : " .$queryUpd_Kardex);
                
            $resultadoUpd_Kardex = mysqli_query($conn, $queryUpd_Kardex);        
            if (!$resultadoUpd_Kardex) {
                    throw new Exception(mysqli_error($conn));
            }
        }    

        //Elimina Detalle de Venta para Evitar la Duplicidad
        $queryDel_Equivalencia = "DELETE FROM equivalencias WHERE producto_id = $nIdProd AND IUD = 'D'";
        $resultadoDel_Equivalencia = mysqli_query($conn, $queryDel_Equivalencia);        
        if (!$resultadoDel_Equivalencia) {
           throw new Exception(mysqli_error($conn));
        }

    }

    // Confirmar la transacción
    mysqli_commit($conn);
    
} catch (Exception $e) {
    // Revertir la transacción en caso de error
    mysqli_rollback($conn);
    $transaccionExitosa = false;
    $errorMensaje = $e->getMessage();
}

// Cerrar la conexión a la base de datos
mysqli_close($conn);

// Enviar una respuesta al cliente
if ($transaccionExitosa) {
    $response = array("ESTADO" => "00", "MENSAJE" => "Los datos se han guardado correctamente");
} else {
    $response = array("ESTADO" => "11", "MENSAJE" => "Error al guardar la información: " . $errorMensaje);
}
echo json_encode($response);

?>